<?php


class AopsSettingsPage extends Aops {

	public function __construct() {
		$this->options = $this->getOptions();
		/* Add Settings page */
		add_action( 'admin_menu', array( $this, 'addSettingsPage' ) );

		/* Register Settings */
		add_action( 'admin_init', array( $this, 'registerSettings' ) );

	}

    public function registerSettings()
    {
		add_settings_section(self::$prefix . 'settings', 'Content Upgrade Settings', array($this, 'displaySettingsSection'), 'aops-cu-settings');
		foreach (self::$pluginOptions as $optionId => $optionName) {
			if (!in_array($optionId, array('ssl_connection_status'))) {
				register_setting(self::$prefix . 'option_group', self::$prefix . $optionId);
				add_settings_field( $optionId, $optionName, array($this, 'dummy'), 'aops-cu-settings', self::$prefix . 'settings' );
			}
		}
    }

	public function addSettingsPage() {
		add_submenu_page( 'edit.php?post_type=' . self::$postTypeName,
			'Content Upgrade Settings',			// page title
            'Settings',							// menu title
            'manage_options',					// capability
            'aops-cu-settings',					// slug
            array( $this, 'displaySettingsPage')// callback);
		);
	}

	public function prepareDefaultAdminEmailFields() {
		return array(
			array(
				'id'			=> 'default_admin_email_enabled', // NOTE: Checking this box DISABLES admin emails
				'name'			=> self::$prefix . 'default_admin_email_enabled',
				'type'			=> 'checkbox',
				'label'			=> 'Check this box to disable all notifications for all Content Upgrades. <p class="aops-small-note">Note: If you want to disable notifications only for specific Content Upgrades, then leave this box unchecked and update this setting on the individual Content Upgrade.</p>',
				'default'		=> self::$pluginDefaultOptionValues['default_admin_email_enabled']
			),
			array(
				'id'			=> 'admin_email',
				'name'			=> self::$prefix . 'admin_email',
				'type'			=> 'text',
				'size'			=> 45,
				'label'			=> 'Default Administrator email',
				'default'		=> '',
				'description'	=> 'Enter the email(s) you want notifications sent to. Defaults to the WordPress administrator email. '
									. '<br>You have the option to override this on each individual Content Upgrade.'
			),

			array(
				'id'			=> 'default_admin_email_subject',
				'name'			=> self::$prefix . 'default_admin_email_subject',
				'type'			=> 'text',
				'size'			=> 45,
				'label'			=> 'Subject',
				'default'		=> self::$pluginDefaultOptionValues['default_admin_email_subject'],
				'description'	=> 'Subject line of the email sent to the administrator'
			),
			array(
				'id'			=> 'default_admin_email_body',
				'name'			=> self::$prefix .'default_admin_email_body',
				'type'			=> 'rich_textarea',
				'height'		=> 200,
				'label'			=> 'Body',
				'description'	=> 'Body of the email sent to the administrator. <br><br>Available substitutions: {user_first_name}, {user_email}, {date_of_entry}, {content_upgrade_title}',
				'default'		=> self::$pluginDefaultOptionValues['default_admin_email_body'],
			)

		);
	}


	public function prepareDefaultUserEmailFields() {
		return array(
			array(
				'id'			=> 'user_email_enabled',
				'name'			=> self::$prefix . 'user_email_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable email to user',
				'default'		=> self::$pluginDefaultOptionValues['user_email_enabled'],
				'description'	=> 'Check this box to make the default behavior of Content Upgrades be that the user will immediately receive a response email'
									.' containing the link to download the bonus content. You can edit or disable this email on individual CUs'
			),
			array(
				'id'			=> 'from_email',
				'name'			=> self::$prefix . 'from_email',
				'type'			=> 'text',
				'size'			=> 45,
				'label'			=> 'From Email',
				'default'		=> '',
				'description'	=> 'Specify the email address that your emails to subscribers will be sent from. Defaults to the administrator email.'
			),
			array(
				'id'			=> 'from_name',
				'name'			=> self::$prefix . 'from_name',
				'type'			=> 'text',
				'size'			=> 45,
				'label'			=> 'From Name',
				'default'		=> '',
				'description'	=> 'Specify the name that your emails to subscribers will be sent from. Defaults to the administrator user\'s first and last name'
			),
			array(
				'id'			=> 'from_name_footnote',
				'name'			=> self::$prefix . 'from_name_footnote',
				'type'			=> 'footnote',
				'size'			=> 45,
				'label'			=> 'From Name',
				'default'		=> 'Not all web hosts support these options. If yours doesn\'t, we recommend you try using the <a href="https://wordpress.org/plugins/wp-mail-smtp/">WP Mail SMTP</a> plugin.',
			),
			array(
				'id'			=> 'default_email_subject',
				'name'			=> self::$prefix . 'default_email_subject',
				'type'			=> 'text',
				'size'			=> 45,
				'label'			=> 'Subject',
				'default'		=> '',
				'description'	=> 'Enter the default email subject line for the email sent to a user when they opt-in for a content upgrade.'
					.' <br>You can override this for each individual content upgrade.'
			),
			array(
				'id'			=> 'default_email_body',
				'name'			=> self::$prefix .'default_email_body',
				'type'			=> 'rich_textarea',
				'height'		=> 200,
				'label'			=> 'Body',
				'description'	=> 'Enter the default email body line for the email sent to a user when they opt-in for a content upgrade. <br>You can override this for each individual content upgrade.<br><br>Available substitutions: {user_first_name}, {user_email}, {date_of_entry}, {content_upgrade_title}, {bonus_content_title_link}, {bonus_content_file}',
				'default'		=> ''
			)
		);
	}

	public function prepareGeneralFields() {

		$fields = array(
			array(
				'id'			=> 'load_cu_main_page',
				'name'			=> self::$prefix . 'load_cu_main_page',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable Content Upgrades on the blog index page',
				'description'	=> 'When checked, content upgrades will work when viewing whichever page is currently set as the blog index page',
				'default'		=> self::$pluginDefaultOptionValues['load_cu_main_page']
			),
			array(
				'id'			=> 'load_cu_category_page',
				'name'			=> self::$prefix . 'load_cu_category_page',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable Content Upgrades on category archives',
				'description'	=> 'When checked, content upgrades will work when viewing category archive pages',
				'default'		=> self::$pluginDefaultOptionValues['load_cu_category_page']
			),
			array(
				'id'			=> 'load_cu_date_page',
				'name'			=> self::$prefix . 'load_cu_date_page',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable Content Upgrades on date archives',
				'description'	=> 'When checked, content upgrades will work when viewing date archive pages',
				'default'		=> self::$pluginDefaultOptionValues['load_cu_date_page']
			),
			array(
				'id'			=> 'load_cu_on_a_template',
				'name'			=> self::$prefix . 'load_cu_on_a_template',
				'type'			=> 'text',
				'size'			=> 20,
				'label'			=> 'Enable CUs on the custom template',
				'description'	=> 'Enter custom template file name (for example, "page-blog.php") if you want to use CUs on pages with that template',
				'default'		=> self::$pluginDefaultOptionValues['load_cu_on_a_template'],
			),
			array(
				'id'			=> 'facebook_conversion_event_enabled',
				'name'			=> self::$prefix . 'facebook_conversion_event_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Fire a Facebook conversion event whenever any content upgrade form has been submitted',
				'description'	=> 'If you\'re using Facebook Ads, and you already have the Facebook Pixel installed on your site, then check this box if you want to fire an event to register a conversion in Facebook anytime someone completes <b>any</b> content upgrade form.<br><br>Note: You must have the Facebook pixel installed on your site (and page where your content upgrades display).<br><br>Also note: You can add additional Facebook conversion events for individual Content Upgrades by editing those Content Upgrades.',
				'default'		=> self::$pluginDefaultOptionValues['facebook_conversion_event_enabled']
			),
			array(
				'id'			=> 'facebook_conversion_event_name',
				'name'			=> self::$prefix . 'facebook_conversion_event_name',
				'type'			=> 'text',
				'size'			=> 20,
				'label'			=> 'Facebook conversion event name',
				'description'	=> 'Give this Facebook conversion event a name, which will register in the Facebook Ads interface.<br><br>For example: Content Upgrade Opt-in',
				'default'		=> self::$pluginDefaultOptionValues['facebook_conversion_event_name'],
				'display'		=> $this->options['facebook_conversion_event_enabled']
			),
			array(
				'id'			=> 'google_analytics_submit_event_enabled',
				'name'			=> self::$prefix . 'google_analytics_submit_event_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Fire a Google Analytics event when content upgrades are submitted.',
				'description'	=> 'Check this box to enable this option on all newly created Content Upgrades going forward.'
					. 'You can also enable/disable this option on an individual Content Upgrade basis. '
					. 'When this option is enabled, when a user submits a content upgrade form, a Google Analytics event '
					. 'called \'Content Upgrade\' will be sent to your Google Analytics account. '
					. 'It\'s description will match the title of the specific Content Upgrade. '
					. 'You must ensure your Google Analytics universal tracking code is installed on your site.',
				'default'		=> self::$pluginDefaultOptionValues['google_analytics_submit_event_enabled']
			),
			array(
				'id'			=> 'global_conversion_event_enabled',
				'name'			=> self::$prefix . 'global_conversion_event_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Trigger a custom JavaScript event whenever any content upgrade form has been submitted',
				'description'	=> 'When this option is enabled, when a user submits a content upgrade form, JS code'
						. ' entered into textarea below will be triggered. '
						. 'If you want to fire a JS event for a single CU, edit that CU and go to it\'s "Misc" tab',
				'default'		=> self::$pluginDefaultOptionValues['global_conversion_event_enabled']
			),
			array(
				'id'			=> 'global_conversion_event_code',
				'name'			=> self::$prefix . 'global_conversion_event_code',
				'type'			=> 'textarea',
				'rows'			=> 4,
				'cols'			=> 45,
				'label'			=> 'Custom JS code',
				'description'	=> htmlspecialchars('Do not include <script> </script> tags'),
				'default'		=> self::$pluginDefaultOptionValues['global_conversion_event_code'],
				'display'		=> $this->options['global_conversion_event_enabled']
			),
		);

		return $fields;
	}

	public function preparePopupsFields() {
		$fields = array(
			array(
				'id'			=> 'download_enabled',
				'name'			=> self::$prefix . 'download_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Display bonus content download link immediately after the form is submitted.',
				'description'	=> 'When checked, for all new content upgrades going forward, the download link and message below will be displayed inside the popup immediately after the form is submitted. '
									. '<br>When unchecked, the user will only see a "Thank You" message and will only receive the download link via email.',
				'default'		=> self::$pluginDefaultOptionValues['download_enabled']
			),
			array(
				'id'			=> 'download_text',
				'name'			=> self::$prefix . 'download_text',
				'type'			=> 'rich_textarea',
				'height'		=> 200,
				'label'			=> 'Text in download popup',
				'description'	=> 'This text is displayed in the popup immediately after the form is submitted. You can override this on an individual Content Upgrades. To insert a link pointing to the bonus download, use this code:  {bonus_content_title_link} ',
				'default'		=> self::$pluginDefaultOptionValues['download_text'],
				'display'		=> $this->options['download_enabled']
			),
			array(
				'id'			=> 'share_buttons_enabled',
				'name'			=> self::$prefix . 'share_buttons_enabled',
				'type'			=> 'checkbox',
				'label'			=> 'Enable social sharing buttons on the download bonus content popup',
				'default'		=> self::$pluginDefaultOptionValues['share_buttons_enabled'],
				'display'		=> $this->options['download_enabled']
			),
			array(
				'id'			=> 'share_buttons_header_text',
				'name'			=> self::$prefix . 'share_buttons_header_text',
				'type'			=> 'text',
				'size'			=> 20,
				'label'			=> 'Sharing Label',
				'description'	=> 'Edit the text shown above the social sharing buttons',
				'default'		=> self::$pluginDefaultOptionValues['share_buttons_header_text'],
				'display'		=> $this->options['download_enabled']
			),
			array(
				'id'			=> 'exit_popup_enabled',
				'name'			=> self::$prefix . 'exit_popup_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable Exit-Intent Popup',
				'description'	=> 'When checked, all new content upgrades created going forward will have the exit-intent popup enabled. '
								. 'This will pop up the Content Upgrade offer when the user\'s mouse exits the page viewport',
				'default'		=> self::$pluginDefaultOptionValues['exit_popup_enabled']
			),

			array(
				'id'				=> 'consent_checkbox_enabled',
				'name'			=> self::$prefix . 'consent_checkbox_enabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable consent checkbox',
				'description'	=> 'Check this box to enable a checkbox below all Content Upgrade opt-in forms, which must be checked in order to submit. After you enable this option, you can customize the label text shown to users.',
				'default'		=> 0
			),
			array(
				'id'				=> 'consent_checkbox_label',
				'name'			=> self::$prefix . 'consent_checkbox_label',
				'type'			=> 'text',
				'size'			=> 20,
				'label'			=> 'Consent checkbox label',
				'default'		=> 'I consent to my contact information being collected',
				'description'	=> 'Label text for the required consent checkbox. Can include HTML, such as a link.',
				'display'		=> $this->options['consent_checkbox_enabled']
			)
		);

		return $fields;
	}

	public function prepareDesignFields() {

		$fields = array(
			array(
				'id'			=> 'button_default_text',
				'name'			=> self::$prefix . 'button_default_text',
				'type'			=> 'text',
				'size'			=> 20,
				'label'			=> 'Default button text',
				'description'	=> 'Enter the default text for the button in popup window'
			)
		);


		foreach (self::$colorPickers as $colorPickerId) {
			$fieldLabel = self::$pluginOptions[$colorPickerId];
			$defaultValue  = self::$pluginDefaultOptionValues[$colorPickerId];

			$fields[] =	array(
				'id'			=> $colorPickerId,
				'name'			=> self::$prefix . $colorPickerId,
				'type'			=> 'color',
				'label'			=> $fieldLabel,
				'default'		=> $defaultValue
			);
		}


		$fields[] =	array(
			'id'			=> 'box_border_style',
			'name'			=> self::$prefix . 'box_border_style',
			'type'			=> 'dropdown',
			'label'			=> 'Box border style',
			'default'		=> 'dashed'
		);

		$fields[] =	array(
			'id'			=> 'box_border_width',
			'name'			=> self::$prefix . 'box_border_width',
			'type'			=> 'text',
			'size'			=> 20,
			'label'			=> 'Box border thickness',
			'default'		=> '2px',
			'description'	=> 'In pixels. Default value is 2px',
		);
		$fields[] =	array(
			'id'			=> 'css_custom_content',
			'name'			=> self::$prefix . 'css_custom_content',
			'type'			=> 'textarea',
			'rows'			=> 5,
			'cols'			=> 41,
			'label'			=> 'Custom CSS',
			'description'	=> 'Add your own custom CSS to override any of the built-in plugin CSS.',
			'default'		=> ''
		);
		$fields[] =	array(
			'id'			=> 'css_disabled',
			'name'			=> self::$prefix . 'css_disabled',
			'type'			=> 'checkbox_with_tooltip',
			'label'			=> 'Disable CSS',
			'description'	=> 'When checked, all front-end CSS from our plugin will be disabled',
			'default'		=> 0
		);


		$fields[] =	array(
			'id'			=> 'last_opened_settings_tab',
			'name'			=> self::$prefix . 'last_opened_settings_tab',
			'type'			=> 'hidden',
			'label'			=> 'Last Opened tab',
			'default'		=> '#cu_tab_design',
		);

		return $fields;
	}

	public function prepareDripIntegrationFields() {
		$fields = array(
			array(
				'id'			=> 'drip_account_id',
				'name'			=> self::$prefix . 'drip_account_id',
				'type'			=> 'text_with_check',
				'check_type'	=> 'option',
				'check_by'		=> 'drip_status',
				'size'			=> 45,
				'label'			=> 'Drip Account Id',
				'description'	=> 'Get your Drip Account Id by logging into Drip, then go to Settings > Site Setup'
			)
		);

		if ($this->options['drip_status'] == self::STATUS_OK) {
			$fields[] = array(
				'id'			=> 'drip_default_tags',
				'name'			=> self::$prefix . 'drip_default_tags',
				'type'			=> 'text',
				'label'			=> 'Default Tags',
				'default'		=> '',
				'size'			=> 45,
				'description'	=> 'Enter the tag(s), separated by comma, which you want to be automatically applied to subscribers when they fill out any Content Upgrade email opt-in. These tags will be applied in addition to any tags set on the individual content upgrade.'
			);

			$fields[] = array(
				'id'			=> 'drip_global_event',
				'name'			=> self::$prefix . 'drip_global_event',
				'type'			=> 'text',
				'label'			=> 'Drip Custom Event',
				'default'		=> '',
				'size'			=> 45,
				'description'	=> "Enter the name of the Custom Event you'd like to send whenever ANY Content Upgrade form is submitted. "
									. "You can define specific Custom Events on individual Content Upgrades as well."
			);
			$fields[] =	array(
				'id'			=> 'drip_script_disabled',
				'name'			=> self::$prefix . 'drip_script_disabled',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Disable including an instance of Drip tracking code',
				'description'	=> 'Useful if some other plugin already includes it.',
				'default'		=> self::$pluginDefaultOptionValues['drip_script_disabled'],
			);
		}
		else {

			$fields[] =	array(
				'id'			=> 'drip_script_disabled',
				'name'			=> self::$prefix . 'drip_script_disabled',
				'type'			=> 'hidden',
				'label'			=> 'Disable including an instance of Drip tracking code',
				'default'		=> self::$pluginDefaultOptionValues['drip_script_disabled'],
			);
		}

		return $fields;
	}

	public function prepareConvertkitIntegrationFields() {
		$fields = array(
			array(
				'id'			=> 'convertkit_api_key',
				'name'			=> self::$prefix . 'convertkit_api_key',
				'type'			=> 'text_with_check',
				'check_type'	=> 'option',
				'check_by'		=> 'convertkit_status',
				'size'			=> 45,
				'label'			=> 'ConvertKit API Key',
				'description'	=> 'Get your ConvertKit API Key by logging into ConvertKit, then go to Account Settings'
			)
		);

		if ($this->options['convertkit_status'] == self::STATUS_OK) {

			// prepare values for dropdown lists
			$forms = AopsConvertKitIntegration::getForms();
			$tags = AopsConvertKitIntegration::getTags();

			if ( is_array( $forms ) ) {

				Aops::$dropdownOptions['convertkit_default_formid']  = $forms;

				$fields[] = array(
					'id'			=> 'convertkit_default_formid',
					'name'			=> self::$prefix . 'convertkit_default_formid',
					'type'			=> 'dropdown',
					'label'			=> 'Default form',
					'default'		=> 0,
					'description'	=> 'Select default ConvertKit form to subscribe users to when they fill out the form for Content Upgrade'
				);

			}

			if ( is_array( $tags ) ) {

				Aops::$dropdownOptions['convertkit_default_tag_ids']  = $tags;

				$fields[] = array(
					'id'			=> 'convertkit_default_tag_ids',
					'name'			=> self::$prefix . 'convertkit_default_tag_ids',
					'type'			=> 'dropdown',
					'label'			=> 'Default tag(s)',
					'multiple'		=> 5,
					'default'		=> array(),
					'description'	=> 'Select default ConvertKit tag(s) which you want to be automatically applied to subscribers when they fill out any Content Upgrade email opt-in. These tags will be applied in addition to any tags set on the individual content upgrade.'
				);

			}

		}
		else {
			$fields[] = array(
				'id'			=> 'convertkit_default_tags',
				'name'			=> self::$prefix . 'convertkit_default_tags',
				'type'			=> 'hidden',
			);
		}

		return $fields;
	}

	public function prepareMailchimpIntegrationFields() {

		$mailchimpFields = array(
			0 => array(
				'id'			=> 'mailchimp_api_key',
				'name'			=> self::$prefix . 'mailchimp_api_key',
				'type'			=> 'text_with_check',
				'check_type'	=> 'option',
				'check_by'		=> 'mailchimp_status',
				'size'			=> 45,
				'label'			=> 'Mailchimp Api Key',
				'description'	=> 'Get your Mailchimp Api Key by logging into Mailchimp, then go to Account > Extras > API keys'
			)
		);

		if ($this->options['mailchimp_status'] == self::STATUS_OK) {
			// prepare values for dropdown list
			$lists = AopsMailchimpIntegration::getMailchimpLists();
		}
		else {
			$lists = false;
		}

		if (is_array($lists)) { // see bug #90
			// prepare values for checkboxes array
			$groupTitles = array();
			$groups = array();


			foreach ($lists as $listId => $listName) {
				$groupTitles[$listId] = AopsMailchimpIntegration::getMailchimpGroupTitles($listId);
				foreach ($groupTitles[$listId] as $groupTitleId => $groupTitle) {
					$groups[$groupTitleId] = AopsMailchimpIntegration::getMailchimpGroups($listId,$groupTitleId);
				}
			}



			$mailchimpFields[2] = array(
				'id'			=> 'mailchimp_default_list',
				'name'			=> self::$prefix . 'mailchimp_default_list',
				'type'			=> 'dropdown',
				'label'			=> 'List',
				'default'		=> 0,
				'description'	=> 'Select default Mailchimp list to subscribe users to when they fill out the form for Content Upgrade'
			);

			if (!$this->options['mailchimp_default_extra_list_id']) {
				$footnoteFields = array(
					3 => array(
						'id'			=> 'mailchimp_footnote',
						'name'			=> self::$metaPrefix . '[mailchimp_footnote]',
						'type'			=> 'footnote',
						'size'			=> 45,
						'label'			=> 'List',
						'default'		=> 'Your list not showing up? <a href="javascript:void(0);" class="toggle_hidden_field" id="toggle_mailchimp_default_extra_list_id">Click here</a>'
					),
					4 => array(
						'id'			=> 'mailchimp_default_extra_list_id',
						'name'			=> self::$prefix . 'mailchimp_default_extra_list_id',
						'type'			=> 'hidden_until_toggle_text',
						'size'			=> 45,
						'label'			=> 'List ID',
						'description'	=> 'Enter your List ID. Find your List ID in Mailchimp by going to Lists > Click the list you want to use > Settings > List name and defaults > Your "List ID" will be shown on this page.<br><br>Once a List ID is entered / saved in this field, the "Groups" should function the same way it does as if a list was selected in the dropdown.'
					)
				);
			}
			else {
				$listId = $this->options['mailchimp_default_extra_list_id'];
				$listName = AopsMailchimpIntegration::checkIfMailchimpListExists($listId);

				if ($listName) {
					$this->options['mailchimp_default_extra_list_status'] = self::STATUS_OK;

					// user entered specific list ID, get groups for this list
					$lists[$listId] = $listName;

					$groupTitles[$listId] = AopsMailchimpIntegration::getMailchimpGroupTitles($listId);

					foreach ($groupTitles[$listId] as $groupTitleId => $groupTitle) {
						$groups[$groupTitleId] = AopsMailchimpIntegration::getMailchimpGroups($listId,$groupTitleId);
					}

				}
				else {
					$this->options['mailchimp_default_extra_list_status'] = self::STATUS_FAIL;
				}

				$footnoteFields = array(
					5 => array(
						'id'			=> 'mailchimp_default_extra_list_id',
						'name'			=> self::$prefix . 'mailchimp_default_extra_list_id',
						'type'			=> 'text_with_check',
						'check_type'	=> 'option',
						'check_by'		=> 'mailchimp_default_extra_list_status',
						'size'			=> 45,
						'label'			=> 'List ID',
						'description'	=> 'Enter your List ID. Find your List ID in Mailchimp by going to Lists > Click the list you want to use > Settings > List name and defaults > Your "List ID" will be shown on this page.<br><br>Once a List ID is entered / saved in this field, the "Groups" should function the same way it does as if a list was selected in the dropdown.'
					)
				);
			}

			$mailchimpGroupFields = array(
				8 => array(
					'id'			=> 'mailchimp_default_groups',
					'name'			=> self::$prefix . 'mailchimp_default_groups',
					'type'			=> 'mailchimp_checkboxes_array',
					'label'			=> 'Group(s)',
					'default'		=> 0,
					'description'	=> 'Select default Mailchimp group(s) to subscribe users to when they fill out the form for Content Upgrade.'
				)
			);

			$mailchimpFields = array_merge($mailchimpFields, $footnoteFields);
			$mailchimpFields = array_merge($mailchimpFields, $mailchimpGroupFields);


			// to use later in Aops::makeMailchimpCheckboxesArray()
			Aops::$dropdownOptions['mailchimp_default_list'] = array_merge( array('0' => 'Please select list') , $lists);

			// ugly hack to make Aops::makeMailchimpCheckboxesArray work properly
			Aops::$dropdownOptions['mailchimp_list'] = Aops::$dropdownOptions['mailchimp_default_list'];

			Aops::$dropdownOptions['mailchimp_group_title'] = $groupTitles;
			Aops::$dropdownOptions['mailchimp_default_groups'] = $groups;

			// another ugly hack to make Aops::makeMailchimpCheckboxesArray work properly
			Aops::$dropdownOptions['mailchimp_groups']  = $groups;

		}

		$mailchimpFields[] = array(
			'id'			=> 'ssl_connection_disabled',
			'name'			=> self::$prefix . 'ssl_connection_disabled',
			'type'			=> 'checkbox_with_tooltip',
			'label'			=> 'Disable SSL check while connecting to Mailchimp',
			'default'		=> self::$pluginDefaultOptionValues['ssl_connection_disabled'],
			'description'	=> 'In some cases secure SSL connection to Mailchimp cannot be established due to server misconfiguration. You may try to disable SSL check. This is unsecure method but allows to connect to the Mailchimp in most cases.'
		);

		return $mailchimpFields;
	}

	public function prepareZapierIntegrationFields() {
		$fields = array(
			array(
				'id'			=> 'zapier_webhook_url',
				'name'			=> self::$prefix . 'zapier_webhook_url',
				'type'			=> 'text',
				'size'			=> 45,
				'label'			=> 'Webhook URL',
				'description'	=> 'Use this option to trigger a Zapier Zap when any Content Upgrade is submitted. Get your Zapier Webhook URL by logging into Zapier and creating a Zap which uses "Content Upgrades by Audience Ops" as the Trigger. If you need help finding this Trigger in Zapier, contact Audience Ops support.'
			),
			array(
				'id'			=> 'zapier_individual_cus',
				'name'			=> self::$prefix . 'zapier_individual_cus',
				'type'			=> 'checkbox',
				'label'			=> 'Check this box to enable Zapier options on individual Content Upgrades',
				'default'		=> self::$pluginDefaultOptionValues['zapier_individual_cus']
			)
		);

		return $fields;
	}

	public function prepareMiscFields() {
		$fields = array(
			array(
				'id'				=> 'disable_event_listener',
				'name'			=> self::$prefix . 'disable_event_listener',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Disable "Click" event listener',
				'description'	=> 'Some themes require this checkbox to be set for popups to work properly',
				'default'		=> 0
			),
			array(
				'id'				=> 'enable_html5_validation',
				'name'			=> self::$prefix . 'enable_html5_validation',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable HTML5 validation',
				'description'	=> 'Some themes require this checkbox to be set for popups to work properly',
				'default'		=> 0
			),
			array(
				'id'				=> 'enable_logging',
				'name'			=> self::$prefix . 'enable_logging',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Enable logging',
				'description'	=> 'This plugin can log CU-related actions and events to help solving problems and fixing bugs. Logging is turned on by default',
				'default'		=> 0
			)
		);

		if ( function_exists( 'get_fields' ) ) { // check for ACF installed
			$fields[] = array(
				'id'				=> 'check_custom_fields_for_cus',
				'name'			=> self::$prefix . 'check_custom_fields_for_cus',
				'type'			=> 'checkbox_with_tooltip',
				'label'			=> 'Check all post\'s custom fields for Content Upgrades',
				'description'	=> 'If you are using custom fields to place Content Upgrades, enable this check for plugin to function correctly. ',
				'default'		=> 0
			);
		}
		return $fields;
	}

	public function displayFieldSet($fieldSet) {
		foreach ($fieldSet as $field) {
			$value = false;

			if ($field['type'] != 'footnote') {
				if ( isset( $this->options[$field['id']] ) ) {
					$value = $this->options[$field['id']];
				}
			}

			if ((!$value) && (!in_array($field['type'],array('checkbox','checkbox_with_tooltip')))) {
				$value = isset($field['default']) ? $field['default'] : '';
			}

			if ((!$value) && ($field['type'] == 'dropdown') && isset($field['multiple']) ) {
				$value = isset($field['default']) ? $field['default'] : array();
			}
			echo $this->makeField($field, $value);
		}
	}

	/**
	 * Triggered when viewing the page
	 */
	public function doPageActions() {
		$this->showLogIfRequested();
		$this->showDebugInfoIfRequested();
	}

	public function showDebugInfoIfRequested() {

		if ( isset( $_GET['show_aopscu_options'] ) && $_GET['show_aopscu_options'] == 'yes' ) {
			echo( '<pre>' . print_r($this->options, 1) . '</pre>' );
		}
	}

	public function displaySettingsPage() {
		if(!current_user_can('manage_options'))
		{
			wp_die(__('You do not have sufficient permissions to access this page.'));
		}
		else {

			$this->doPageActions();

			$tabs = array(
				'general'		=> 'General settings',
				'design'		=> 'Design',
				'popups'		=> 'Popups',
				'email'			=> 'Email',
				'integrations'	=> 'Integrations',
				'misc'			=> 'Misc'
			);

			$defaultAdminEmailFields = $this->prepareDefaultAdminEmailFields();
			$defaultUserEmailFields = $this->prepareDefaultUserEmailFields();

			$generalFields								= $this->prepareGeneralFields();
			$popupsFields									= $this->preparePopupsFields();
			$designFields									= $this->prepareDesignFields();
			$dripIntegrationFields				= $this->prepareDripIntegrationFields();
			$convertkitIntegrationFields	= $this->prepareConvertkitIntegrationFields();
			$mailchimpIntegrationFields		= $this->prepareMailchimpIntegrationFields();
			$zapierIntegrationFields			= $this->prepareZapierIntegrationFields();
			$miscFields										= $this->prepareMiscFields();

		?>
		<div class="wrap cu-settings-wrap">
            <h2>Content Upgrade Settings</h2>
            <form method="post" action="options.php">
				<?php settings_fields( self::$prefix . 'option_group' );?>
				<div id="cu_tab_container" class="tab-container" style="margin-top:25px">
					<ul class='etabs'>
						<?php foreach ($tabs as $tabId => $tabName) : ?>
							<li class='ao-tab' id="tab_<?php echo $tabId; ?>"><a href="#cu_tab_<?php echo $tabId; ?>"><?php echo $tabName; ?></a></li>
						<?php endforeach; ?>
					</ul>
					<div class='panel-container' style="border: solid #ccc 1px">
						<div id="cu_tab_general">
							<table class="form-table-wide">
								<?php $this->displayFieldSet($generalFields); ?>
							</table>
						</div>
						<div id="cu_tab_design">
							<table class="form-table-wide">
								<?php $this->displayFieldSet($designFields); ?>
							</table>
						</div>
						<div id="cu_tab_popups">
							<table class="form-table-wide">
								<?php $this->displayFieldSet($popupsFields); ?>
							</table>
						</div>
						<div id="cu_tab_email">
							<table class="form-table-wide">
								<tr class="ao-settings-header"><td colspan="3"><h3>Email to Administrator</h3></td></tr>
								<?php $this->displayFieldSet($defaultAdminEmailFields); ?>
								<tr class="ao-settings-header"><td colspan="3"><br><br><h3>Default email to user</h3></td></tr>
								<?php $this->displayFieldSet($defaultUserEmailFields); ?>
							</table>
						</div>
						<div id="cu_tab_integrations">
							<div id="settings_integrations">
								<h3><span class="dashicons dashicons-arrow-right-alt2"></span>Drip</h3>
								<div>
									<table class="form-table-wide">
										<?php $this->displayFieldSet($dripIntegrationFields); ?>
									</table>
								</div>
								<h3><span class="dashicons dashicons-arrow-right-alt2"></span>ConvertKit</h3>
								<div>
									<table class="form-table-wide">
										<?php $this->displayFieldSet($convertkitIntegrationFields); ?>
									</table>
								</div>
								<h3><span class="dashicons dashicons-arrow-right-alt2"></span>Mailchimp</h3>
								<div>
									<?php $this->displayMailchimpNote(); ?>
									<table class="form-table-wide">
										<?php $this->displayFieldSet($mailchimpIntegrationFields); ?>
									</table>
								</div>
								<h3><span class="dashicons dashicons-arrow-right-alt2"></span>Zapier</h3>
								<div>
									<table class="form-table-wide">
										<?php $this->displayFieldSet($zapierIntegrationFields); ?>
									</table>
								</div>
							</div>
						</div>
						<div id="cu_tab_misc">
							<table class="form-table-wide">
								<?php $this->displayFieldSet($miscFields); ?>
							</table>
						</div>
					</div>	<!-- / .panel-container -->
				</div> <!-- / #cu_tab_container -->
            <?php
                submit_button();
            ?>
            </form>
        </div>
		<?php
		}
	}


	public function showLogIfRequested() {
		if ( isset( $_GET['show_logs'] ) && $_GET['show_logs'] == 'yes' ) {
			if ( isset( $_GET['log_days'] ) && intval($_GET['log_days']) > 0 ) {
				$days_before = $_GET['log_days'];
				$start_time = strtotime("-$days_before days");
				$start_date = date( 'Y-m-d H:i:s', $start_time);
			}
			else {
				$start_date = 0;
			}
			$log_entries = self::getLogs( $start_date );


			echo '<div style="width:100%">';
			echo '<h2>Logs for requested period of time ( since ' . $start_date . ').</h2>';

			if ( count( $log_entries ) ) {

				foreach ($log_entries as $entry) {
					$decoded_data = json_decode( $entry['data'], true );

					if ( is_array($decoded_data) ) {
						if ( isset( $decoded_data['source'] ) ) {
							$source = $decoded_data['source'];
							unset( $decoded_data['source'] );
						}
						else {
							$source = '';
						}
					}
					else {
						$decoded_data = $entry['data']; // array( 'json' => 'false', 'data' => $entry['data'] );
						$source = '';
					}

					echo('<div style="background-color:#fdf"><span>' . $entry['created_at'] . ' :: ' . $source . '</span></div>');
					if ( is_array( $decoded_data ) ) {
						if ( isset( $decoded_data['message'] ) ) {
							echo('<div style="background-color:#dfd">' . $decoded_data['message'] . '</div>');
							unset( $decoded_data['message'] );
						}
						echo( '<div style="width:700px;"> <pre style="white-space: pre-wrap;">' . htmlspecialchars( print_r( $decoded_data, 1 ) ) . '</pre></div>' );
					}
					else {
						echo('<div style="background-color:#dfd">no json</div>');
						echo( '<div style="width:700px;"> <pre style="white-space: pre-wrap;">' . htmlspecialchars( print_r( $decoded_data, 1 ) ) . '</pre></div>' );
					}
				}

			}
			else {
				echo '<h3>None found</h3>';
			}
			echo '</div>';
		}
	}


	public function displayMailchimpNote() {
		$out = '';
		if ($this->options['mailchimp_status'] != self::STATUS_OK) {
			$status = $this->options['ssl_connection_status'];
			if (is_array($status) && isset($status['result'])) {
				if (!$status['result']) {
					$out = '<div class="maichimp_connection_note">';
					$out .= 'Uh oh! It appears your web hosting server is missing the configurations required to make Mailchimp integration work. ';

					if (!$status['curl'] || !$status['local_ssl'] || !$status['ssl_location']) {
						$out .= 'Specifically, these things will need to be enabled:';
						$out .= '<ul>';
						$out .= '<li>cURL extension: ' . $this->displayStatus($status['curl']) . '</li>';
						$out .= '<li>Local copy of SSL certificate: ' . $this->displayStatus($status['local_ssl']) . '</li>';
						$out .= '<li>Properly configured SSL certificate location: ' . $this->displayStatus($status['ssl_location']) . ' </li>';
						$out .= '</ul>';

						$out .= 'Please contact your web hosting provider and ask them to configure these things.';
					}
					else {
						$out .= "Probably something is wrong with your server's SSL certificate. Please contact your web hosting provider and ask them to configure your server";
					}

					if ($status['message']) {
						$out .= '<p><strong>Error message from server:</strong> <div class="error_message">' . $status['message'] .'</div></p>';
					}

					$out .= '</div>';
				}
			}
		}

		echo $out;
	}

	public function getSslStatus() {
		$status = $this->options['ssl_connection_status'];
		/*
		$status = array(
			'curl'	=> true,
			'local_ssl' => false
		);
		 *
		 */
		return $status;
	}

	public function displayStatus($status) {
		return $status ? '<span class="status_ok">enabled</span>' : '<span class="status_fail">not enabled</span>';
	}
}
?>
